function new_plot_zoom(X_T,Y_T,T,X_Vx_T,Y_Vx_T,VX_T,VY_T,X_V_rot,Y_V_rot,VX_V_rot,VY_V_rot,xf_V_rot,yf_V_rot,H_shearheat,Lx_T,Ly_T,y_T,time)

    % Modify the X Y units (from meters to km)
    X_T = X_T.*1e-3;
    Y_T = Y_T.*1e-3;
    X_Vx_T = X_Vx_T.*1e-3;
    Y_Vx_T = Y_Vx_T.*1e-3;
    X_V_rot = X_V_rot.*1e-3;
    Y_V_rot = Y_V_rot.*1e-3;
    VX_V_rot = VX_V_rot.*1e-3;
    xf_V_rot = xf_V_rot.*1e-3;
    yf_V_rot = yf_V_rot.*1e-3;
    Lx_T = Lx_T.*1e-3;
    Ly_T = Ly_T.*1e-3;
    

% ZOOM ON THE RAMP
    
    figure(2); clf, colormap(jet)
    
    %Temperature
    contourf(X_T,Y_T,T-273.15,15,'w'); shading interp
    hold on
    quiv = quiver(X_Vx_T(2:end,:),Y_Vx_T(2:end,:),VX_T(2:end,:),VY_T(:,2:end))
    hold on
    % Fault
    plot(xf_V_rot,yf_V_rot,'-k','Linewidth',1.5)
    hold on

    %PLOT SETTINGS
    axis equal
    text(0.8*Lx_T,1.2*max(y_T),strcat('Time = ',num2str(ceil(time./(3600*24*365*1e6))),'Myr'))
    title({'Thermokinematic Model of Nappe formation'; 'Zoom on the Ramp'})
    xlabel('Length [km]'),ylabel('Depth [km]')
    axis([15 Lx_T/2 0 Ly_T])

    set(gcf,'paperunits','normalized','position',[805 189.8000 712.8000 546.4000])
    set(get(colorbar,'label'),'string','Temperature [°C]');
    hold on

    drawnow
    
end